/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.formatter.nodes;

import com.aptana.formatter.IFormatterContext;
import com.aptana.formatter.IFormatterDocument;
import com.aptana.formatter.IFormatterWriter;
import com.aptana.formatter.nodes.AbstractFormatterNode;
import com.aptana.formatter.nodes.IFormatterContainerNode;
import com.aptana.formatter.nodes.IFormatterNode;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FormatterBlockNode
extends AbstractFormatterNode
implements IFormatterContainerNode {
    private final List<IFormatterNode> body = new ArrayList<IFormatterNode>();

    public FormatterBlockNode(IFormatterDocument document) {
        super(document);
    }

    protected void acceptNodes(List<IFormatterNode> nodes, IFormatterContext context, IFormatterWriter visitor) throws Exception {
        for (IFormatterNode node : nodes) {
            context.enter(node);
            node.accept(context, visitor);
            context.leave(node);
        }
    }

    @Override
    public void addChild(IFormatterNode child) {
        this.body.add(child);
    }

    @Override
    public void accept(IFormatterContext context, IFormatterWriter visitor) throws Exception {
        this.acceptBody(context, visitor);
    }

    protected void acceptBody(IFormatterContext context, IFormatterWriter visitor) throws Exception {
        this.acceptNodes(this.body, context, visitor);
    }

    @Override
    public int getEndOffset() {
        if (!this.body.isEmpty()) {
            return this.body.get(this.body.size() - 1).getEndOffset();
        }
        return 0;
    }

    @Override
    public int getStartOffset() {
        if (!this.body.isEmpty()) {
            return this.body.get(0).getStartOffset();
        }
        return 0;
    }

    @Override
    public boolean isEmpty() {
        for (IFormatterNode node : this.body) {
            if (node.isEmpty()) continue;
            return false;
        }
        return true;
    }

    @Override
    public List<IFormatterNode> getChildren() {
        return Collections.unmodifiableList(this.body);
    }

    @Override
    public String toString() {
        return this.body.toString();
    }

    @Override
    public List<IFormatterNode> getBody() {
        return this.body;
    }

    protected boolean isIndenting() {
        return false;
    }

    protected boolean isAddingBeginNewLine() {
        return false;
    }

    protected boolean isAddingEndNewLine() {
        return false;
    }
}

